(function ($) {
  'use strict';
  $.fn.extend({
    qlwapp: function () {

      var $qlwapp = $(this);
      // Ready!
      // -----------------------------------------------------------------------
      $qlwapp.addClass('qlwapp-js-ready');

      // Height
      // -----------------------------------------------------------------------

      $qlwapp.on('qlwapp.height', function (e) {

        console.log('heoght');

        var $container = $(e.delegateTarget),
                $carousel = $container.find('.qlwapp-carousel'),
                $body = $container.find('.qlwapp-body');

        var $header = $container.find('.qlwapp-header'),
                $footer = $container.find('.qlwapp-footer'),
                height = ($(window).innerHeight() - $header.outerHeight() - $footer.outerHeight());

        if (!/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) {
          height = ($(window).innerHeight() * 0.666 - $header.outerHeight() - $footer.outerHeight());
        }

        $body.add($carousel).css({'max-height': height + 'px'});

      });

      // Toggle
      // -----------------------------------------------------------------------

      $qlwapp.on('qlwapp.toggle', function (e) {

        var $container = $(e.delegateTarget),
                $box = $container.find('.qlwapp-box');

        $container.addClass('qlwapp-transition');

        $box.removeClass('response texting');

        setTimeout(function () {
          $container.toggleClass('qlwapp-show').trigger('qlwapp.height');
        }, 10);

        setTimeout(function () {
          $container.toggleClass('qlwapp-transition');
        }, 300);

      });

      // Click
      // -----------------------------------------------------------------------
      $qlwapp.on('click', '.qlwapp-toggle, .qlwapp-close', function (e) {
        e.preventDefault();

        $(e.delegateTarget).trigger('qlwapp.toggle');

      });

      // Whatsapp
      // -----------------------------------------------------------------------

      $qlwapp.on('click', 'a[data-action=open]', function (e) {

        var url = 'https://api.whatsapp.com/send';

        if (!/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) {
          url = 'https://web.whatsapp.com/send';
        }

        $(this).attr('href', url + '?phone=' + $(this).data('phone') + '&text=' + $(this).data('message'));
      });

      // Response
      // -----------------------------------------------------------------------

      $qlwapp.on('click', '.qlwapp-previous', function (e) {
        e.preventDefault();

        var $container = $(e.delegateTarget),
                $box = $container.find('.qlwapp-box'),
                $user = $box.find('.qlwapp-user');

        $box.addClass('closing');

        setTimeout(function () {
          $box.removeClass('response').removeClass('closing');
          $box.removeClass('texting')
          $user.empty();
        }, 300);

      });

      $qlwapp.on('click', 'a[data-action=chat]', function (e) {
        e.preventDefault();

        var $contact = $(this),
                $container = $(e.delegateTarget),
                $box = $container.find('.qlwapp-box'),
                avatar = $contact.find('.qlwapp-avatar > img').attr('src'),
                name = $contact.find('.qlwapp-name').text(),
                label = $contact.find('.qlwapp-label').text(),
                //url = $contact.data('url'),
                message = $contact.data('message'),
                phone = $contact.data('phone');

        $box.addClass('response').addClass('opening');

        $container.trigger('qlwapp.height');

        setTimeout(function () {
          $box.removeClass('opening');
        }, 300);

        var $reply = $box.find('.qlwapp-reply'),
                $header = $box.find('.qlwapp-header'),
                $avatar = $header.find('.qlwapp-avatar > img'),
                $number = $header.find('.qlwapp-number'),
                $name = $header.find('.qlwapp-name'),
                $label = $header.find('.qlwapp-label'),
                $message = $box.find('.qlwapp-message');


        $reply.data('phone', phone);//.data('message', message);
        $avatar.attr('src', avatar);
        $number.html(phone);
        $name.html(name);
        $label.html(label);
        $message.html(message);

      });

      // Response
      // -----------------------------------------------------------------------

      $qlwapp.on('keyup', '.qlwapp-response', function (e) {
        e.preventDefault();

        var $textarea = $(this).find('textarea'),
                $pre = $(this).find('pre'),
                $reply = $(this).find('.qlwapp-reply'),
                $container = $(e.delegateTarget),
                $box = $container.find('.qlwapp-box'),
                $user = $box.find('.qlwapp-user'),
                $buttons = $box.find('.qlwapp-buttons');

        $pre.html($textarea.val());

        setTimeout(function () {
          $box.addClass('texting').css({'padding-bottom': $pre.outerHeight()});
          $buttons.addClass('active');
          var message = $textarea.val();

          $user.html(message);

          $reply.data('message', message);

          if (message == '') {
            $box.removeClass('texting');
            $buttons.removeClass('active');

            //setTimeout(function () {
            //$user.empty();
            //$pre.empty();
            //}, 300);
          }

        }, 300);

      });
    }
  });

  $( document ).ready(function() {
    $('#qlwapp').qlwapp();
  });

  $(window).on('resize', function (e) {
    if (!/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) {
      $('#qlwapp.qlwapp-show').trigger('qlwapp.toggle');
    }

    $('#qlwapp.qlwapp-show').trigger('qlwapp.height');
  });

  $(document).on('click', function (e) {
    if (!$(e.target).closest('#qlwapp.qlwapp-show').length) {
      $('#qlwapp.qlwapp-show').trigger('qlwapp.toggle');
    }
  });

}(jQuery));