<?php
/*
 * Copyright (c) 2017-2020 Aimy Extensions, Netzum Sorglos Software GmbH
 * Copyright (c) 2015-2017 Aimy Extensions, Lingua-Systems Software GmbH
 *
 * https://www.aimy-extensions.com/
 *
 * License: GNU GPLv2, see LICENSE.txt within distribution and/or
 *          https://www.aimy-extensions.com/software-license.html
 */
 namespace AimySitemap; defined( '_JEXEC' ) or die(); class HierarchyNode { private $id = null; private $data = null; private $hierarchy = null; public function __construct( $id, $data = null ) { if ( ! is_scalar( $id ) ) { throw new InvalidArgumentException( 'Invalid id argument' ); } $this->id = $id; $this->data = $data; } public function has_data() { return ( ! is_null( $this->data ) ); } public function get_data() { return $this->data; } public function add_data( $data ) { $this->data = $data; } public function add_child( $id, $data ) { if ( is_null( $this->hierarchy ) ) { $this->hierarchy = new Hierarchy(); } $this->hierarchy->add( $id, $data ); } public function has_subhierarchy() { return is_object( $this->hierarchy ); } public function get_subhierarchy() { return $this->hierarchy; } } class Hierarchy { static private $id_separator = '/'; private $elements = array(); public function add( $id, $data = null ) { if ( ! is_scalar( $id ) ) { throw new InvalidArgumentException( 'Invalid id argument' ); } $id = trim( $id, self::$id_separator ); $id = empty( $id ) ? '_' : $id; if ( strpos( $id, self::$id_separator ) === false ) { if ( isset( $this->elements[ $id ] ) ) { $this->elements[ $id ]->add_data( $data ); } else { $this->elements[ $id ] = new HierarchyNode( $id, $data ); } } else { $idp = explode( self::$id_separator, $id ); $fid = array_shift( $idp ); if ( ! isset( $this->elements[ $fid ] ) ) { $this->elements[ $fid ] = new HierarchyNode( $fid, null ); } $this->elements[ $fid ]->add_child( implode( self::$id_separator, $idp ), $data ); } return $this; } public function prune() { $prune_ids = array(); foreach ( $this->elements as $id => $e ) { if ( ! $e->has_data() && $e->has_subhierarchy() ) { array_push( $prune_ids, $id ); } if ( $e->has_subhierarchy() ) { $e->get_subhierarchy()->prune(); } } if ( ! count( $prune_ids ) ) { return; } foreach ( $prune_ids as $i => $id ) { $e = $this->elements[ $id ]; if ( $e->has_subhierarchy() ) { $ses = $e->get_subhierarchy()->get_elements(); foreach( $ses as $sid => $se ) { $this->elements[ $sid ] = $se; } } unset( $this->elements[ $id ] ); } return $this; } public function get_elements() { return $this->elements; } public function render( $cb_level = null, $cb_node = null, $lvl = 1 ) { $cb_level_called = false; if ( ! is_callable( $cb_level ) ) { $cb_level = function ( $ctx, $lvl ) { echo str_repeat( "\t", $lvl ), ( $ctx == 'open' ? '[[' : ']]' ), "\n"; }; } if ( ! is_callable( $cb_node ) ) { $cb_node = function ( $ctx, $lvl, &$data ) { echo str_repeat( "\t", $lvl+1 ), serialize( $data ), "\n"; }; } foreach ( $this->elements as $id => $e ) { $ed = $e->get_data(); if ( ! empty( $ed ) ) { if ( ! $cb_level_called ) { $cb_level( 'open', $lvl ); $cb_level_called = true; } $cb_node( 'open', $lvl, $ed ); } if ( $e->has_subhierarchy() ) { $e->get_subhierarchy()->render( $cb_level, $cb_node, $lvl+1 ); } if ( ! empty( $ed ) ) { $cb_node( 'close', $lvl, $ed ); } } if ( $cb_level_called ) { $cb_level( 'close', $lvl ); } return $this; } public function sort( $cb = null ) { if ( ! is_callable( $cb ) ) { return; } uasort( $this->elements, $cb ); foreach ( $this->elements as $id => $e ) { if ( $e->has_subhierarchy() ) { $e->get_subhierarchy()->sort( $cb ); } } return $this; } } 
