<?php
/*
 * Copyright (c) 2017-2020 Aimy Extensions, Netzum Sorglos Software GmbH
 * Copyright (c) 2015-2017 Aimy Extensions, Lingua-Systems Software GmbH
 *
 * https://www.aimy-extensions.com/
 *
 * License: GNU GPLv2, see LICENSE.txt within distribution and/or
 *          https://www.aimy-extensions.com/software-license.html
 */
 define( '_JEXEC', 1 ); if ( strtolower( php_sapi_name() ) != 'cli' ) { if ( is_array( $_SERVER ) ) { if ( ! isset( $_SERVER[ 'REMOTE_ADDR' ] ) && ! isset( $_SERVER[ 'SERVER_SOFTWARE' ] ) ) { echo str_repeat( '#', 72 ), PHP_EOL, 'ERROR: ', 'You are currently using the ', php_sapi_name(), ' ', 'PHP interpreter to run Aimy Sitemap\'s periodic crawl.', PHP_EOL, 'ERROR: ', 'For security reasons, using the PHP *CLI* interpreter is ', 'required.', PHP_EOL, 'ERROR: ', 'If in doubt, ask your administrator for the path to the ', 'system\'s PHP *CLI* interpreter.', PHP_EOL, str_repeat( '#', 72 ), PHP_EOL; } } die(); } $opt_q = false; if ( count( $argv ) > 1 && ( $argv[1] == '-q' or $argv[1] == '--quiet' ) ) { $opt_q = true; } @error_reporting( -1 ); @ini_set( 'display_errors', 1 ); $path_sm = dirname( __FILE__ ) . '/..'; $path_jroot = $path_sm . '/../../..'; define( 'JPATH_BASE', realpath( $path_jroot ) ); require_once( $path_jroot . '/includes/defines.php' ); if ( file_exists( $path_jroot . '/includes/framework.php' ) ) { require_once( $path_jroot . '/includes/framework.php' ); } else { require_once( JPATH_LIBRARIES . '/import.legacy.php' ); require_once( JPATH_LIBRARIES . '/cms.php' ); } require_once( ( defined( 'JPATH_CONFIGURATION' ) ? JPATH_CONFIGURATION : $path_jroot ) . '/configuration.php' ); jimport( 'joomla.application.cli' ); if ( class_exists( 'JConfig' ) ) { $jc = new JConfig(); if ( isset( $jc->offset ) ) { date_default_timezone_set( $jc->offset ); } if ( isset( $jc->debug ) && ! defined( 'JDEBUG' ) ) { define( 'JDEBUG', $jc->debug ); } } else { date_default_timezone_set( 'UTC' ); } $_SERVER[ 'HTTP_HOST' ] = ''; class AimySitemapCliCrawl extends JApplicationCli { private $path_comp = null; private $params = null; private $stats = null; private $crawler = null; private $quiet = false; private $has_settl = false; private $timelimit = 0; private $pcid = 0; static private $base_url = null; const MAX_OUT_LINES = 1000; const PCID_KVSTORE_KEY = 'periodic-current-id'; public function __construct( $quiet = false ) { $this->path_comp = dirname( __FILE__ ) . DIRECTORY_SEPARATOR . '..'; require_once( $this->path_comp . '/helpers/logger.php' ); require_once( $this->path_comp . '/helpers/kvstore.php' ); require_once( $this->path_comp . '/Crawler.php' ); require_once( $this->path_comp . '/Sitemap.php' ); $sm = JComponentHelper::getComponent( 'com_aimysitemap' ); if ( empty( $sm ) or ! is_object( $sm ) ) { throw new RuntimeException( 'Failed to load AimySitemap' ); } JFactory::getLanguage()->load( 'com_aimysitemap', JPATH_ADMINISTRATOR ); parent::__construct(); JFactory::$application = $this; JFactory::$session = new JObject(); self::set_juri_vars(); $this->quiet = $quiet; $this->params = $sm->params; $this->crawler = new AimySitemapCrawler(); $this->timelimit = intVal( @ini_get( 'max_execution_time' ) ); $this->stats = array( 'url_count' => 0, 'errors' => array() ); $this->pcid = time(); } public function doExecute() { if ( empty( self::$base_url ) ) { $this->enqueueMessage( 'Failed to retrieve base URL', 'error' ); return $this->close( 1 ); } if ( preg_match( '#:(\d+)/#', self::$base_url, $port ) && ! preg_match( '#:\d+/#', JURI::root() ) ) { $this->enqueueMessage( 'Failed to set port (' . $port[1] . ') of root URI. ' . 'Continuing anyway.', 'error' ); self::$base_url = preg_replace( '#:' . $port[1] . '/#', '/', self::$base_url ); } if ( JURI::root() != self::$base_url ) { $this->enqueueMessage( 'Failed to set base URL to ' . self::$base_url . ' ' . '(is: ' . JURI::root() . ')', 'error' ); return $this->close( 1 ); } $this->check_cpanel_jailshell(); $this->initialize(); $this->crawl(); if ( ! defined( 'JDEBUG' ) or ! JDEBUG ) { $this->rebuild(); if ( $this->stats[ 'change_count' ] && $this->params->get( 'periodic_write' ) ) { $this->write(); if ( $this->params->get( 'periodic_notify' ) ) { $this->notify(); } } } $this->show_report(); return $this->close( 0 ); } private function initialize() { $this->has_settl = $this->has_usable_set_time_limit(); $this->stats[ 'time_start' ] = time(); $this->enqueueMessage( 'Aimy Sitemap v28.1 Periodic Crawl starts, ' . date( 'Y-m-d H:i:s', $this->stats[ 'time_start' ] ) . ', ' . 'time limit: ' . ( $this->timelimit ? $this->timelimit . ' second(s)' : 'not set' ) . ', ' . 'set_time_limit: ' . ( $this->has_settl ? '' : 'not ' ) . 'usable, ' . 'PHP: ' . ( defined( 'PHP_BINARY' ) ? PHP_BINARY : ( isset( $_SERVER[ '_' ] ) ? $_SERVER[ '_' ] : '-' ) ) . ' (' . PHP_VERSION . ')' ); if ( $this->timelimit && ! $this->has_settl ) { $this->enqueueMessage( 'Your system enforces a time limit on command line ' . 'scripts. ' . 'The execution time may be too short for the crawler ' . 'to finish crawling your website! ' . 'If periodic crawling does not work, please ask your ' . 'system administrator to remove the limit.', 'warning' ); } $this->check_other_crawl_running(); AimySitemapKVStore::set( self::PCID_KVSTORE_KEY, $this->pcid ); $this->enqueueMessage( 'Initializing crawl of ' . JURI::root() . '...' ); $this->stats[ 'url_count' ]++; $url = JURI::root( true ); $line = sprintf( '  %03d: %s', $this->stats[ 'url_count' ], empty( $url ) ? '/' : $url ); $res = null; try { $res = $this->crawler->initialize(); } catch ( Exception $e ) { $this->enqueueMessage( $line ); $this->enqueueMessage( $e->getMessage(), 'error' ); return $this->close( 1 ); } if ( ! empty( $res ) && isset( $res[ 'msg' ] ) ) { $line .= ' (' . $res[ 'msg' ] . ')'; } $this->enqueueMessage( $line ); if ( empty( $res ) or ! isset( $res[ 'ok' ] ) or ! $res[ 'ok' ] ) { $msg = 'Failed to initialize crawl'; if ( isset( $res[ 'msg' ] ) ) { $msg .= ' (' . $res[ 'msg' ] . ')'; } $this->enqueueMessage( $msg, 'error' ); return $this->close( 1 ); } $this->save_report(); } private function crawl() { $finished = false; while ( ! $finished ) { $res = null; try { $res = $this->crawler->crawl(); } catch ( Exception $e ) { $this->enqueueMessage( $e->getMessage(), 'error' ); return $this->close( 1 ); } if ( isset( $res[ 'abort' ] ) && $res[ 'abort' ] ) { if ( $this->stats[ 'url_count' ] < 2 ) { $this->enqueueMessage( 'Crawling finished after visiting the first URL ' . 'of your website. The crawler could either not ' . 'find any link or following the links has been ' . 'forbidden (nofollow). Please check your ' . 'configuration.', 'error' ); return $this->close( 1 ); } $finished = true; continue; } $msg = ''; if ( isset( $res[ 'url' ] ) ) { $this->stats[ 'url_count' ]++; $msg .= sprintf( '  %03d: %s', $this->stats[ 'url_count' ], $res[ 'url' ] ); } if ( isset( $res[ 'msg' ] ) ) { $msg .= ' (' . $res[ 'msg' ] . ')'; } if ( ! isset( $res[ 'ok' ] ) or ! $res[ 'ok' ] ) { $this->enqueueMessage( $msg, 'error' ); } else { $this->enqueueMessage( $msg ); } if ( $this->stats[ 'url_count' ] % 10 == 0 ) { JURI::reset(); } if ( $this->stats[ 'url_count' ] % 50 == 0 ) { $this->save_report(); } $this->refresh_time_limit(); } $this->stats[ 'time_end' ] = time(); } private function rebuild() { $this->enqueueMessage( 'Rebuilding sitemap index...' ); try { $sm = new AimySitemapSitemap(); $this->refresh_time_limit(); $this->stats[ 'stats' ] = $sm->rebuild(); } catch ( Exception $e ) { $this->enqueueMessage( $e->getMessage(), 'error' ); return $this->close( 1 ); } $this->refresh_time_limit(); if ( AimySitemapConfigHelper::get_once( 'linkcheck_enable', true ) ) { require_once( $this->path_comp . '/LinkCheck.php' ); try { $lc = new AimySitemapLinkCheck(); $cnt = $lc->rebuild(); $this->enqueueMessage( 'Link Check: ' . $cnt . ' broken links found.' ); } catch ( Exception $e ) { $this->enqueueMessage( $e->getMessage(), 'error' ); return $this->close( 1 ); } } $this->refresh_time_limit(); try { AimySitemapCrawler::delete_crawl_data(); } catch ( Exception $e ) { $this->enqueueMessage( $e->getMessage(), 'error' ); } $this->stats[ 'change_count' ] = count( $this->stats[ 'stats' ][ 'added' ] ) + count( $this->stats[ 'stats' ][ 'deleted' ] ) + count( $this->stats[ 'stats' ][ 'updated' ] ); } private function write() { $this->enqueueMessage( 'Writing sitemap file...' ); $sm = new AimySitemapSitemap(); $ok = false; try { $ok = $sm->write_sitemap_file(); } catch ( Exception $e ) { $this->enqueueMessage( $e->getMessage(), 'error' ); return $this->close( 1 ); } if ( ! $ok ) { return $this->close( 1 ); } } private function notify() { require_once( $this->path_comp . '/Notifier.php' ); $rv = false; try { $rv = AimySitemapNotifier::ping_all_enabled(); } catch ( Exception $e ) { $this->enqueueMessage( $e->getMessage(), 'error' ); return $this->close( 1 ); } if ( $rv ) { return $this->enqueueMessage( 'Notification ping(s) sent.' ); } return $this->enqueueMessage( 'Failed to send notification ping(s)', 'error' ); } private function save_report() { $this->stats[ 'time_last_save' ] = time(); if ( is_array( $this->stats[ 'out' ] ) && count( $this->stats[ 'out' ] ) > self::MAX_OUT_LINES ) { $sz = intVal( self::MAX_OUT_LINES / 2 ); $this->stats[ 'out' ] = array_merge( array_slice( $this->stats[ 'out' ], 0, $sz ), array( '...' ), array_slice( $this->stats[ 'out' ], count( $this->stats[ 'out' ] ) - ( $sz + 1 ), $sz ) ); } AimySitemapKVStore::set( 'periodic_report', serialize( $this->stats ) ); } public function close( $code = 0 ) { $this->stats[ 'code' ] = $code; $this->save_report(); AimySitemapKVStore::delete( self::PCID_KVSTORE_KEY ); exit( $code ); } private function show_report() { if ( defined( 'JDEBUG' ) && JDEBUG ) { $this->enqueueMessage( 'No changes done (debugging crawl)' ); } else { $this->enqueueMessage( sprintf( '%d added, %d deleted, %d updated', count( $this->stats[ 'stats' ][ 'added' ] ), count( $this->stats[ 'stats' ][ 'deleted' ] ), count( $this->stats[ 'stats' ][ 'updated' ] ) ) ); } } private function has_usable_set_time_limit() { if ( ! function_exists( 'set_time_limit' ) or intVal( ini_get( 'safe_mode' ) ) === 1 ) { return false; } $dis = ini_get( 'disable_functions' ) . ',' . ini_get( 'suhosin.executor.func.blacklist' ); if ( strpos( $dis, 'set_time_limit' ) !== false ) { return false; } return set_time_limit( $this->timelimit ); } private function refresh_time_limit() { if ( $this->timelimit && $this->has_settl ) { @set_time_limit( $this->timelimit ); } } static private function set_juri_vars() { JURI::reset(); self::$base_url = $url = AimySitemapKVStore::get( 'base-url' ); if ( empty( $url ) ) { return false; } $urlp = parse_url( $url ); if ( isset( $urlp[ 'scheme' ] ) && $urlp[ 'scheme' ] == 'https' ) { $_SERVER[ 'HTTPS' ] = 1; } $path = preg_replace( '#/{2,}#', '/', ( isset( $urlp[ 'path' ] ) ? $urlp[ 'path' ] : '/' ) . '/index.php' ); $_SERVER[ 'HTTP_HOST' ] = $urlp[ 'host' ]; $_SERVER[ 'REQUEST_URI' ] = $path; $_SERVER[ 'PHP_SELF' ] = $path; $_SERVER[ 'SCRIPT_NAME' ] = $path; return true; } private function check_cpanel_jailshell() { $sh = getenv( 'SHELL' ); if ( empty( $sh ) ) { return false; } $sh = basename( strtolower( $sh ) ); if ( $sh != 'jailshell' ) { return false; } $jc = new JConfig(); if ( $jc->host != 'localhost' ) { return false; } $this->enqueueMessage( 'Aimy Sitemap: Periodic crawl started in in CPanel\'s jailshell ' . 'environment and you use a socket-based database connection. ' . 'If you experience errors connecting to the database, ' . 'switch to a TCP/IP-based database connection: use the ' . 'IP address of the database host rather than its hostname. ' . 'For example, set "127.0.0.1" instead of "localhost" in ' . 'Joomla!\'s "Global Configuration".', 'warning' ); return true; } private function check_other_crawl_running() { $rid = AimySitemapKVStore::get( self::PCID_KVSTORE_KEY ); if ( ! empty( $rid ) ) { $this->enqueueMessage( 'Aimy Sitemap: Another periodic crawl seems to be currently ' . 'running (started at ' . date( 'Y-m-d H:i:s', intVal( $rid ) ) . '). ' . 'This may lead to undefined behaviour and cause errors. ' . 'Make sure only one (1) periodic crawl is running at a time.', 'warning' ); return true; } return false; } public function enqueueMessage( $msg, $type = 'message' ) { $this->stats[ 'out' ][] = $msg; if ( $type == 'error' or $type == 'warning' ) { $this->stats[ 'errors' ][] = $msg; return $this->out( strtoupper( $type ) . ': ' . strip_tags( $msg ) ); } if ( $this->quiet ) { return; } $this->out( strip_tags( $msg ) ); } public function getMenu( $name = null, $opt = array() ) { return null; } public function getName() { return 'Aimy Sitemap Periodic Crawl'; } public function getCfg( $key, $dflt = null ) { $jc = new JConfig(); return ( isset( $jc->{$key} ) ? $jc->{$key} : $dflt ); } } $app = new AimySitemapCliCrawl( $opt_q ); $app->execute(); 
