<?php
/*
 * Copyright (c) 2017-2020 Aimy Extensions, Netzum Sorglos Software GmbH
 * Copyright (c) 2014-2017 Aimy Extensions, Lingua-Systems Software GmbH
 *
 * https://www.aimy-extensions.com/
 *
 * License: GNU GPLv2, see LICENSE.txt within distribution and/or
 *          https://www.aimy-extensions.com/software-license.html
 */
 defined( '_JEXEC' ) or die(); require_once( JPATH_ADMINISTRATOR . '/components/com_aimysitemap/helpers/config.php' ); require_once( JPATH_ADMINISTRATOR . '/components/com_aimysitemap/Uri.php' ); require_once( JPATH_ADMINISTRATOR . '/components/com_aimysitemap/helpers/kvstore.php' ); require_once( JPATH_ADMINISTRATOR . '/components/com_aimysitemap/helpers/compat.php' ); jimport( 'joomla.filesystem.file' ); jimport( 'cms.plugin.helper' ); class AimySitemapSitemap { private $written_f2t = array(); static private $sitenames = array(); static private $jpagetitles = array(); static private $langs = array( 'known' => array(), 'map' => array() ); const URL_UNCHANGED = 0; const URL_ADDED = 1; const URL_UPDATED = 2; const MAX_URLS_PER_SITEMAP = 50000; public function add_or_update_url( $obj ) { $db = JFactory::getDbo(); if ( empty( self::$langs[ 'known' ] ) ) { foreach ( AimySitemapCompatHelper::getKnownLanguages() as $k => $a ) { self::$langs[ 'known' ][ $a[ 'tag' ] ] = 1; $lf = substr( $a[ 'tag' ], 0, 2 ); if ( ! isset( self::$langs[ 'map' ][ $lf ] ) ) { self::$langs[ 'map' ][ $lf ] = $a[ 'tag' ]; } } } $q = $db->getQuery( true ); $q->select( $db->quoteName( array( 'id', 'url', 'title', 'mtime', 'lock', 'lang' ) ) ) ->from( $db->quoteName( '#__aimysitemap' ) ) ->where( $db->quoteName( 'url' ) . ' = ' . $db->quote( $obj->url ) ) ->setLimit( 1 ); $db->setQuery( $q ); $obj_db = $db->loadObject(); if ( isset( $obj->lang ) && $obj->lang !== '*' && ! isset( self::$langs[ 'known' ][ $obj->lang ] ) && strlen( $obj->lang ) >= 2 ) { $l = strtolower( substr( $obj->lang, 0, 2 ) ); if ( isset( self::$langs[ 'map' ][ $l ] ) ) { $obj->lang = self::$langs[ 'map' ][ $l ]; } } if ( empty( $obj_db ) ) { $cfg = new AimySitemapConfigHelper(); if ( ! isset( $obj->priority ) ) { $obj->priority = $cfg->get( 'default_priority', 1.0 ); } if ( ! isset( $obj->state ) ) { $obj->state = $cfg->get( 'default_state', 1 ); } if ( ! isset( $obj->changefreq ) ) { $obj->changefreq = $cfg->get( 'default_changefreq', 'monthly' ); } $db->insertObject( '#__aimysitemap', $obj ); return self::URL_ADDED; } $upd = new JObject(); if ( isset( $obj->mtime ) and $obj->mtime > $obj_db->mtime ) { $upd->mtime = $obj->mtime; } $is_locked = ( isset( $obj_db->lock ) and $obj_db->lock ); if ( ! $is_locked and isset( $obj->title ) and $obj->title != $obj_db->title ) { $upd->title = $obj->title; } if ( ! $is_locked and isset( $obj->lang ) and $obj->lang != $obj_db->lang ) { $upd->lang = $obj->lang; } if ( isset( $upd->mtime ) or isset( $upd->title ) or isset( $upd->lang ) ) { $upd->id = $obj_db->id; $db->updateObject( '#__aimysitemap', $upd, 'id' ); return self::URL_UPDATED; } return self::URL_UNCHANGED; } public function rebuild() { $db = JFactory::getDbo(); $stats = array( 'added' => array(), 'updated' => array(), 'deleted' => array() ); $q = $db->getQuery( true ); $q->select( $db->quoteName( array( 'url', 'title', 'mtime', 'lang' ) ) ) ->from( $db->quoteName( '#__aimysitemap_crawl' ) ) ->where( $db->quoteName( 'index' ) . ' = 1 ' . 'AND ' . $db->quoteName( 'code' ) . ' = 200 ' ); $db->setQuery( $q ); $urls = $db->loadObjectList(); foreach ( $urls as $obj ) { self::strip_sitename_from_title( $obj ); $rv = $this->add_or_update_url( $obj ); switch ( $rv ) { case self::URL_ADDED: $stats[ 'added' ][] = $obj->url; break; case self::URL_UPDATED: $stats[ 'updated' ][] = $obj->url; break; } } $q = $db->getQuery( true ); $q->select( $db->quoteName( array( 'id', 'url' ) ) ) ->from( '#__aimysitemap' ); $db->setQuery( $q ); $objs_db = $db->loadObjectList(); foreach ( $objs_db as $obj_db ) { $found = false; foreach ( $urls as $obj ) { if ( $obj_db->url == $obj->url ) { $found = true; break; } } if ( ! $found ) { $q = $db->getQuery( true ); $q->delete( '#__aimysitemap' ) ->where( $db->quoteName( 'id' ) . ' = ' . $db->quote( $obj_db->id ) ); $db->setQuery( $q ); $db->execute(); $stats[ 'deleted' ][] = $obj_db->url; } } return $stats; } public function write_sitemap_file() { require_once( JPATH_ADMINISTRATOR . '/components/com_aimysitemap/helpers/message.php' ); $cfg = new AimySitemapConfigHelper(); $msg = new AimySitemapMessageHelper(); $rel_path = $cfg->get( 'xml_path' ); if ( empty( $rel_path ) ) { $msg->error( JText::_( 'AIMY_SM_MSG_XML_FILE_NOT_SET' ) ); return false; } $domain = null; $proto = null; try { $proto = AimySitemapKVStore::get( 'crawl-protocol' ); } catch ( Exception $e ) { } $cncl = self::get_canonical_data(); if ( ! empty( $cncl ) ) { if ( ! empty( $cncl[ 'domain' ] ) ) { $domain = $cncl[ 'domain' ]; $msg->message( JText::sprintf( 'AIMY_SM_MSG_CANONICAL_DOMAIN_USED', $domain ) ); } if ( ! empty( $cncl[ 'protocol' ] ) ) { $proto = $cncl[ 'protocol' ]; $msg->message( JText::sprintf( 'AIMY_SM_MSG_CANONICAL_PROTOCOL_USED', $proto ) ); } } if ( empty( $domain ) ) { $domain = self::get_current_domain(); } if ( empty( $proto ) ) { $proto = self::get_current_protocol(); } $db = JFactory::getDbo(); $q = $db->getQuery( true ); $q->select( $db->quoteName( array( 'url', 'priority', 'mtime', 'changefreq' ) ) ) ->from( $db->quoteName('#__aimysitemap' ) ) ->where( $db->quoteName( 'state' ) . '=' . '1' ); $db->setQuery( $q ); $rows = $db->loadObjectList(); $row_count = count( $rows ); $include_changefreq = $cfg->get( 'xml_include_changefreq', true ); $include_lastmod = $cfg->get( 'xml_include_lastmod', true ); $compress = $cfg->get( 'xml_gz_enable', false ); if ( $row_count > self::MAX_URLS_PER_SITEMAP ) { $file_count = ceil( $row_count / self::MAX_URLS_PER_SITEMAP ); $path_name = JFile::stripExt( $rel_path ); $path_ext = JFile::getExt( $rel_path ); $sitemaps = array(); for ( $si = 0; $si < $file_count; $si++ ) { $part_rel_path = $path_name . '-' . ( $si + 1 ); if ( $path_ext ) { $part_rel_path .= '.' . $path_ext; } $part_urls = array_slice( $rows, $si * self::MAX_URLS_PER_SITEMAP, self::MAX_URLS_PER_SITEMAP ); $rv = $this->write_sitemap_xml_file( $part_urls, $proto, $domain, $part_rel_path, $msg, $include_changefreq, $include_lastmod, $compress ); if ( ! $rv ) { return false; } $sitemaps[] = $part_rel_path . ( $compress && function_exists( 'gzencode' ) ? '.gz' : '' ); } $rv = $this->write_sitemap_index_xml_file( $sitemaps, $rel_path, $proto, $domain, $include_lastmod, $msg ); if ( ! $rv ) { return false; } } else { $rv = $this->write_sitemap_xml_file( $rows, $proto, $domain, $rel_path, $msg, $include_changefreq, $include_lastmod, $compress ); if ( ! $rv ) { return false; } } if ( ! $include_changefreq ) { $msg->message( JText::sprintf( 'AIMY_SM_MSG_XML_TAG_OMITTED', 'changefreq' ) ); } if ( ! $include_lastmod ) { $msg->message( JText::sprintf( 'AIMY_SM_MSG_XML_TAG_OMITTED', 'lastmod' ) ); } self::unlink_file_if_exists( $this->written_f2t ); try { AimySitemapKVStore::set( 'written-sitemaps', $this->written_f2t ); } catch ( Exception $e ) { } return true; } public static function unlink_file_if_exists( $except = false ) { require_once( JPATH_ADMINISTRATOR . '/components/com_aimysitemap/helpers/message.php' ); $cfg = new AimySitemapConfigHelper(); $msg = new AimySitemapMessageHelper(); $rel_paths = false; try { $rel_paths = AimySitemapKVStore::get( 'written-sitemaps' ); } catch ( Exception $e ) { return false; } if ( $rel_paths === '' ) { $rel_path = $cfg->get( 'xml_path' ); if ( empty( $rel_path ) ) { return false; } $rel_paths = array( $rel_path ); if ( $cfg->get( 'xml_gz_enable', false ) ) { $rel_paths[] = $rel_path . '.gz'; } } $ok = true; foreach ( $rel_paths as $rel_path ) { if ( is_array( $except ) && in_array( $rel_path, $except ) ) { continue; } $full_path = JPATH_ROOT . '/' . $rel_path; if ( ! JFile::exists( $full_path ) ) { continue; } if ( JFile::delete( $full_path ) === true ) { $msg->message( JText::sprintf( 'AIMY_SM_MSG_XML_FILE_REMOVED', $rel_path ) ); } else { $msg->error( JText::sprintf( 'AIMY_SM_MSG_XML_FILE_ERR_REMOVE', $rel_path ) ); $ok = false; } } try { AimySitemapKVStore::delete( 'written-sitemaps' ); } catch ( Exception $e ) { } return $ok; } static private function initialize_sitename_list() { $app = JFactory::getApplication(); $db = JFactory::getDbo(); $sn = trim( $app->getCfg( 'sitename', '' ) ); if ( ! empty( $sn ) ) { self::$sitenames[] = $sn; } try { $q = $db->getQuery( true ); $q->select( $db->quoteName( 'sitename' ) ) ->from( $db->quoteName( '#__languages' ) ) ->where( $db->quoteName( 'published' ) . '=' . '1' ); $db->setQuery( $q ); $rows = $db->loadObjectList(); foreach ( $rows as $row ) { $sn = trim( $row->sitename ); if ( ! empty( $sn ) ) { self::$sitenames[] = $sn; } } } catch ( Exception $e ) { } } static private function initialize_jpagetitle_list() { $db = JFactory::getDbo(); $langs = AimySitemapCompatHelper::getKnownLanguages(); $jpts = array(); foreach ( array_keys( $langs ) as $lang ) { $over_path = JPATH_SITE . DIRECTORY_SEPARATOR . 'language' . DIRECTORY_SEPARATOR . 'overrides' . DIRECTORY_SEPARATOR . "$lang.override.ini"; if ( JFile::exists( $over_path ) ) { $cnt = @file_get_contents( $over_path ); if ( $cnt !== false ) { $cnt = str_replace( '_QQ_', '"\""', $cnt ); $ors = @parse_ini_string( $cnt ); if ( is_array( $ors ) ) { if ( isset( $ors[ 'JPAGETITLE' ] ) && ! empty( $ors[ 'JPAGETITLE' ] ) ) { $jpts[ $ors[ 'JPAGETITLE' ] ] = 1; continue; } } } } $jo = JLanguage::getInstance( $lang ); if ( $jo->load( 'joomla', JPATH_SITE ) ) { $jpt = $jo->_( 'JPAGETITLE' ); if ( ! empty( $jpt ) ) { $jpts[ $jpt ] = 1; } } } if ( empty( $jpts ) ) { $jpts[ '%1$s - %2$s' ] = 1; } self::$jpagetitles = array_keys( $jpts ); } static private function strip_sitename_from_title( &$obj ) { if ( ! isset( $obj->title ) or empty( $obj->title ) ) { return; } $app = JFactory::getApplication(); $pos = (int) $app->getCfg( 'sitename_pagetitles', 0 ); if ( empty( $pos ) ) { return; } if ( empty( self::$sitenames ) or empty( self::$jpagetitles ) ) { self::initialize_sitename_list(); self::initialize_jpagetitle_list(); } $title = ''; $mark = '@MARK@'; switch ( $pos ) { case 1: foreach ( self::$sitenames as $sn ) { foreach ( self::$jpagetitles as $jpt ) { $mtitle = sprintf( $jpt, $sn, $mark ); $mpos = strpos( $mtitle, $mark ); if ( $mpos === false ) { continue; } $prefix = substr( $mtitle, 0, $mpos ); if ( strpos( $obj->title, $prefix ) === 0 ) { $title = substr( $obj->title, strlen( $prefix ) ); break; } } if ( ! empty( $title ) ) { break; } } break; case 2: $title_len = strlen( $obj->title ); foreach ( self::$sitenames as $sn ) { foreach ( self::$jpagetitles as $jpt ) { $mtitle = sprintf( $jpt, $mark, $sn ); $mpos = strpos( $mtitle, $mark ); if ( $mpos === false ) { continue; } $suffix = substr( $mtitle, $mpos + strlen( $mark ) ); $suffix_len = strlen( $suffix ); if ( $suffix_len > $title_len ) { continue; } $diff = substr_compare( $obj->title, $suffix, $title_len - $suffix_len, $suffix_len ); if ( $diff === 0 ) { $title = substr( $obj->title, 0, $title_len - $suffix_len ); break; } } if ( ! empty( $title ) ) { break; } } break; } if ( ! empty( $title ) ) { $obj->title = trim( $title ); } } static private function get_canonical_data() { if ( ! JPluginHelper::isEnabled( 'system', 'aimycanonical' ) ) { return null; } $p = JPluginHelper::getPlugin( 'system', 'aimycanonical' ); if ( $p && isset( $p->params ) ) { $r = new JRegistry(); $r->loadString( $p->params ); $cfg = array( 'domain' => null, 'protocol' => null ); $d = $r->get( 'domain', null ); if ( ! empty( $d ) ) { $d = preg_replace( '#^https?://#', '', $d ); $d = preg_replace( '#/.*$#', '', $d ); $d = trim( $d ); if ( ! empty( $d ) ) { $cfg[ 'domain' ] = $d; } } $p = $r->get( 'protocol', null ); if ( ! empty( $p ) ) { $cfg[ 'protocol' ] = $p; } return $cfg; } return null; } static private function get_current_domain() { $u = new JURI( JURI::root() ); return $u->getHost(); } static private function get_current_protocol() { $u = new JURI( JURI::root() ); return $u->getScheme(); } private function write_sitemap_xml_file( &$urls, $proto, $domain, $rel_path, $msg, $include_changefreq, $include_lastmod, $compress ) { $xml = array( '<?xml version="1.0" encoding="UTF-8"?>', '<urlset ' . 'xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" ' . 'xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9 ' . 'http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd" ' . 'xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">' ); foreach ( $urls as $url ) { $u = new AimySitemapURI( $url->url ); $s = '<url>' . '<loc>' . $proto . '://' . $domain . $u->getResourceHref() . '</loc>'; if ( $include_lastmod && $url->mtime ) { $s .= '<lastmod>' . date( 'Y-m-d', $url->mtime ) . '</lastmod>'; } if ( $include_changefreq ) { $s .= '<changefreq>' . $url->changefreq . '</changefreq>'; } $s .= '<priority>' . sprintf( '%.1f', $url->priority ) . '</priority>' . '</url>'; $xml[] = $s; } $xml[] = '</urlset>'; $full_path = JPATH_ROOT . '/' . $rel_path; $sitemap_xml = implode( "\n", $xml ); if ( JFile::write( $full_path, $sitemap_xml ) == false ) { $msg->error( JText::sprintf( 'AIMY_SM_MSG_XML_FILE_ERR_WRITE', $full_path ) ); return false; } $this->written_f2t[] = $rel_path; $msg->message( JText::sprintf( 'AIMY_SM_MSG_XML_FILE_UPDATED', $rel_path ) ); if ( $compress ) { if ( ! function_exists( 'gzencode' ) ) { $msg->error( 'Cannot generate ' . basename( $rel_path ) . '.gz - ' . 'gzencode() function missing.' ); } else { $rel_path_gz = $rel_path . '.gz'; $full_path_gz = JPATH_ROOT . '/' . $rel_path_gz; $sitemap_xml_gz = gzencode( $sitemap_xml, 9 ); if ( $sitemap_xml_gz === false or JFile::write( $full_path_gz, $sitemap_xml_gz ) == false ) { $msg->error( JText::sprintf( 'AIMY_SM_MSG_XML_FILE_ERR_WRITE', $full_path_gz ) ); return false; } $this->written_f2t[] = $rel_path_gz; $msg->message( JText::sprintf( 'AIMY_SM_MSG_XML_GZ_FILE_UPDATED', $rel_path_gz ) ); } } return true; } private function write_sitemap_index_xml_file( &$sitemaps, $rel_path, $proto, $domain, $include_lastmod, $msg ) { $xml = array( '<?xml version="1.0" encoding="UTF-8"?>', '<sitemapindex xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">' ); foreach ( $sitemaps as $sm ) { $u = new AimySitemapURI( $proto . '://' . $domain . '/' . $sm ); $s = '<sitemap>' . '<loc>' . $proto . '://' . $domain . $u->getResourceHref() . '</loc>'; if ( $include_lastmod ) { $s .= '<lastmod>' . date( 'Y-m-d' ) . '</lastmod>'; } $s .= '</sitemap>'; $xml[] = $s; } $xml[] = '</sitemapindex>'; $full_path = JPATH_ROOT . '/' . $rel_path; $sitemap_xml = implode( "\n", $xml ); if ( JFile::write( $full_path, $sitemap_xml ) == false ) { $msg->error( JText::sprintf( 'AIMY_SM_MSG_XML_INDEX_FILE_ERR_WRITE', $full_path ) ); return false; } $this->written_f2t[] = $rel_path; $msg->message( JText::sprintf( 'AIMY_SM_MSG_XML_INDEX_FILE_UPDATED', $rel_path ) ); return true; } } 
