<?php
/*
 * Copyright (c) 2017-2020 Aimy Extensions, Netzum Sorglos Software GmbH
 * Copyright (c) 2016-2017 Aimy Extensions, Lingua-Systems Software GmbH
 *
 * https://www.aimy-extensions.com/
 *
 * License: GNU GPLv2, see LICENSE.txt within distribution and/or
 *          https://www.aimy-extensions.com/software-license.html
 */
 defined( '_JEXEC' ) or die(); require_once( JPATH_ADMINISTRATOR . '/components/com_aimysitemap/helpers/config.php' ); require_once( JPATH_ADMINISTRATOR . '/components/com_aimysitemap/Uri.php' ); require_once( JPATH_ADMINISTRATOR . '/components/com_aimysitemap/helpers/kvstore.php' ); class AimySitemapLinkCheck { private $db = null; public function __construct() { $this->db = JFactory::getDbo(); } public function rebuild() { $this->reset_table(); $count = 0; $q = $this->db->getQuery( true ); $q->select( $this->db->quoteName( array( 'url', 'refs' ) ) ) ->from( $this->db->quoteName( '#__aimysitemap_crawl' ) ) ->where( $this->db->quoteName( 'code' ) . ' = 404' ); $this->db->setQuery( $q ); $urls = $this->db->loadObjectList(); foreach ( $urls as $url ) { $obj = new StdClass(); $obj->url = $url->url; $obj->srcs = json_encode( $this->get_link_sources( $url->url ) ); $this->db->insertObject( '#__aimysitemap_broken_links', $obj ); $count++; } AimySitemapKVStore::set( 'linkcheck-done', 1 ); return $count; } private function get_link_sources( &$url ) { $q = $this->db->getQuery( true ); $q->select( $this->db->quoteName( 'url' ) ) ->from( $this->db->quoteName( '#__aimysitemap_crawl' ) ) ->where( $this->db->quoteName( 'refs' ) . ' LIKE ' . $this->db->quote( '% ' . $url . ' %' ) ); $this->db->setQuery( $q ); return $this->db->loadColumn(); } public function get_edit_links( $broken_url, $srcs ) { $buvs = self::guess_url_variants( $broken_url ); $srcs = $this->resolve_menu_item_links( $srcs ); $els = $this->get_module_edit_links( $buvs ); foreach ( $srcs as $src ) { $els = array_merge( $els, $this->get_com_content_article_edit_link( $src, $buvs ), $this->get_com_content_category_edit_link( $src, $buvs ) ); } return array_values( $els ); } private function reset_table() { AimySitemapKVStore::delete( 'linkcheck-done' ); return $this->db->truncateTable( '#__aimysitemap_broken_links' ); } private function resolve_home_page() { static $hp = false; if ( $hp ) { return $hp; } $q = $this->db->getQuery( true ); $q->select( $this->db->quoteName( array( 'link' ) ) ) ->from( $this->db->quoteName( '#__menu' ) ) ->where( $this->db->quoteName( 'home' ) . ' = ' . $this->db->quote( 1 ) ); $this->db->setQuery( $q ); $row = $this->db->loadRow(); if ( ! empty( $row ) ) { $hp = $row[ 0 ]; return $hp; } return false; } private function resolve_menu_item_links( $srcs ) { $re = '#^.*?([^/]+?)(?:\.html)?$#'; $new = array(); foreach ( $srcs as $url ) { if ( self::is_home_page( $url ) ) { $hp = $this->resolve_home_page(); if ( $hp ) { $new[] = $hp; } continue; } if ( ! preg_match( $re, $url, $m ) || count( $m ) !== 2 ) { continue; } $alias = $m[ 1 ]; $q = $this->db->getQuery( true ); $q->select( $this->db->quoteName( array( 'link' ) ) ) ->from( $this->db->quoteName( '#__menu' ) ) ->where( $this->db->quoteName( 'client_id' ) . ' = ' . $this->db->quote( 0 ) . ' AND ' . $this->db->quoteName( 'published' ) . ' = ' . $this->db->quote( 1 ) . ' AND ' . ' ( ' . $this->db->quoteName( 'type' ) . ' = ' . $this->db->quote( 'component' ) . ' OR ' . $this->db->quoteName( 'type' ) . ' = ' . $this->db->quote( 'url' ) . ' ) ' . ' AND ' . $this->db->quoteName( 'alias' ) . ' = ' . $this->db->quote( $alias ) ); $this->db->setQuery( $q ); $row = $this->db->loadRow(); if ( ! empty( $row ) ) { $new[] = $row[ 0 ]; } } return array_merge( $srcs, $new ); } private function get_module_edit_links( $buvs ) { $res = array(); $where = $this->db->quoteName( 'published' ) . ' = ' . $this->db->quote( 1 ) . ' AND ' . ' ( '; foreach ( $buvs as $i => $url ) { $where .= $this->db->quoteName( 'content' ) . ' LIKE ' . $this->db->quote( '% href=%' . $url . '%' ); if ( self::is_image_url( $url ) ) { $where .= ' OR ' . $this->db->quoteName( 'content' ) . ' LIKE ' . $this->db->quote( '% src=%' . $url . '%' ); } if ( $i + 1 < count( $buvs ) ) { $where .= ' OR '; } } $where .= ' )'; $q = $this->db->getQuery( true ); $q->select( $this->db->quoteName( array( 'id', 'title' ) ) ) ->from( $this->db->quoteName( '#__modules' ) ) ->where( $where ); $this->db->setQuery( $q ); $rows = $this->db->loadRowList(); foreach ( $rows as $row ) { $res[ 'module:' . $row[ 0 ] ] = self::gen_edit_link_object( 'index.php?option=com_modules&task=module.edit&id=' . $row[ 0 ], $row[ 1 ], 'module' ); } return $res; } private function get_com_content_article_edit_link( $url, $buvs ) { $re_nsef = '#\bindex\.php\?option=com_content&view=article&(.*)$#'; $re_sef = '#/(\d+)-([^/]+?)(?:\.html)?$#'; $id = false; $alias = false; $res = array(); if ( preg_match( $re_nsef, $url, $m ) && count( $m ) === 2 ) { $qs = $m[ 1 ]; if ( preg_match( '#id=(\d+)#', $qs, $m ) ) { $id = $m[ 1 ]; } } elseif ( preg_match( $re_sef, $url, $m ) && count( $m ) === 3 ) { $id = $m[ 1 ]; $alias = $m[ 2 ]; } if ( ! $id ) { return $res; } $q = $this->db->getQuery( true ); $where = $this->db->quoteName( 'id' ) . ' = ' . $this->db->quote( $id ) . ' AND ' . $this->db->quoteName( 'state' ) . ' > ' . $this->db->quote( 0 ) . ' AND ' . $this->db->quoteName( 'access' ) . ' = ' . $this->db->quote( 1 ); if ( $alias ) { $where .= ' AND ' . $this->db->quoteName( 'alias' ) . ' = ' . $this->db->quote( $alias ); } $where .= ' AND ( '; foreach ( $buvs as $i => $url ) { $where .= $this->db->quoteName( 'introtext' ) . ' LIKE ' . $this->db->quote( '% href=%' . $url . '%' ) . ' OR ' . $this->db->quoteName( 'fulltext' ) . ' LIKE ' . $this->db->quote( '% href=%' . $url . '%' ); if ( self::is_image_url( $url ) ) { $where .= ' OR ' . $this->db->quoteName( 'introtext' ) . ' LIKE ' . $this->db->quote( '% src=%' . $url . '%' ) . ' OR ' . $this->db->quoteName( 'fulltext' ) . ' LIKE ' . $this->db->quote( '% src=%' . $url . '%' ); } if ( $i + 1 < count( $buvs ) ) { $where .= ' OR '; } } $where .= ')'; $q->select( $this->db->quoteName( array( 'id', 'title' ) ) ) ->from( $this->db->quoteName( '#__content' ) ) ->where( $where ); $this->db->setQuery( $q ); $row = $this->db->loadRow(); if ( ! empty( $row ) && $row[ 0 ] == $id ) { $res[ 'com_content.article:' . $id ] = self::gen_edit_link_object( 'index.php?option=com_content&task=article.edit&id=' . $id, $row[ 1 ], 'article' ); } return $res; } private function get_com_content_category_edit_link( $url, $buvs ) { $re_nsef = '#\bindex\.php\?option=com_content&view=category&(.*)$#'; $re_sef = '#\b(\d+)-([^/]+?)(?:\.html)?$#'; $id = false; $alias = false; $res = array(); if ( preg_match( $re_nsef, $url, $m ) && count( $m ) === 2 ) { $qs = $m[ 1 ]; if ( preg_match( '#id=(\d+)#', $qs, $m ) ) { $id = $m[ 1 ]; } } elseif ( preg_match( $re_sef, $url, $m ) && count( $m ) === 3 ) { $id = $m[ 1 ]; $alias = $m[ 2 ]; } if ( ! $id ) { return $res; } $q = $this->db->getQuery( true ); $where = $this->db->quoteName( 'extension' ) . ' = ' . $this->db->quote( 'com_content' ) . ' AND ' . $this->db->quoteName( 'id' ) . ' = ' . $this->db->quote( $id ) . ' AND ' . $this->db->quoteName( 'published' ) . ' = ' . $this->db->quote( 1 ); if ( $alias ) { $where .= ' AND ' . $this->db->quoteName( 'alias' ) . ' = ' . $this->db->quote( $alias ); } $where .= ' AND ( '; foreach ( $buvs as $i => $url ) { $where .= $this->db->quoteName( 'description' ) . ' LIKE ' . $this->db->quote( '% href=%' . $url . '%' ); if ( self::is_image_url( $url ) ) { $where .= ' OR ' . $this->db->quoteName( 'description' ) . ' LIKE ' . $this->db->quote( '% src=%' . $url . '%' ); } if ( $i + 1 < count( $buvs ) ) { $where .= ' OR '; } } $where .= ')'; $q->select( $this->db->quoteName( array( 'id', 'title' ) ) ) ->from( $this->db->quoteName( '#__categories' ) ) ->where( $where ); $this->db->setQuery( $q ); $row = $this->db->loadRow(); if ( ! empty( $row ) && $row[ 0 ] == $id ) { $res[ 'com_content.category:' . $id ] = self::gen_edit_link_object( 'index.php?option=com_categories&task=category.edit&' . 'extension=com_content&id=' . $id, $row[ 1 ], 'category' ); } return $res; } static private function gen_edit_link_object( $link, $name, $type ) { $o = new StdClass(); $o->link = $link; $o->name = $name; $o->type = $type; return $o; } static private function guess_url_variants( $url ) { $o = array(); if ( preg_match( '#^\Q'.JUri::root( true ).'\E/?(.*)$#', $url, $m ) && strlen( $m[ 1 ] ) > 3 ) { $url = $m[ 1 ]; } $o[] = $url; if ( preg_match( '#(\d+)-([^/]+?)(?:\.html)?$#', $url, $m ) ) { $o[] = '&id=' . $m[ 1 ] . ':' . $m[ 2 ] . '&'; $o[] = '&view=article&id=' . $m[ 1 ] . '&'; } if ( preg_match( '#^(.*)&Itemid=\d+$#', $url, $m ) ) { $o[] = $m[ 1 ]; } $cnt = count( $o ); for ( $i = 0; $i < $cnt; $i++ ) { if ( strpos( $o[ $i ], '&' ) !== false && strpos( $o[ $i ], '&amp;' ) === false ) { $o[] = htmlspecialchars( $o[ $i ] ); } } return $o; } static private function is_image_url( $url ) { return ( preg_match( '#.(?:jpg|png|bmp|tiff)(?:\?.*)?$#', $url ) === 1 ); } static private function is_home_page( $url ) { static $root = false; if ( ! $root ) { $root = JUri::root( true ); } return ( preg_match( '#^\Q' . $root . '\E(?:/*|/*index\.php/*)?$#', $url ) === 1 ); } } 
